<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Auth;

class UserController extends Controller
{
    public function loginAsReseller($id)
    {
        $user = User::findOrFail($id);
        $currentLoginId = Auth::id();
        if($user && $user->id != $currentLoginId) {
            $token = generateRandomString(16);
            session(['user.idbeforeswitch.id' => $currentLoginId]);
            session(['user.idbeforeswitch.token' => $token]);
            Auth::logout();
            Auth::login($user);
            return redirect()->route('home')->with('info', 'Welcome to Reseller Account');
        }
        return redirect()->route('users.index')->with('error', 'Reseller Not Found');
    }

    public function goBackToAdmin($token = null)
    {
        if($token) {
            if(session()->exists('user.idbeforeswitch.token') && session()->exists('user.idbeforeswitch.id')) {
                $storedToken = session('user.idbeforeswitch.token');
                $storedId = session('user.idbeforeswitch.id');
                if($storedToken == $token) {
                    $user = User::findOrFail($storedId);
                    if($user) {
                        session()->forget('user.idbeforeswitch.token');
                        session()->forget('user.idbeforeswitch.id');
                        Auth::logout();
                        Auth::login($user);
                        return redirect()->route('users.index')->with('info', 'Welcome to Admin Account');
                    }
                }
            }
        }
        return redirect()->route('home');
    }

    public function edit($id)
    {
        $user = User::findOrFail($id);
        return view('users.edit', compact('user'));
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);
    
        $request->validate([
            'username' => 'required|unique:users,username,' . $user->id,
            'email' => 'required|email|unique:users,email,' . $user->id,
            'password' => 'nullable|min:6',
            'role' => 'required|in:reseller,admin',
        ]);
    
        $user->username = $request->input('username');
        $user->email = $request->input('email');
        if ($request->has('password')) {
            $user->password = Hash::make($request->input('password'));
        }
        $user->role = $request->input('role');
        $user->save();
    
        return redirect()->route('users.index')->with('success', 'User information updated successfully.');
    }
    
    // UserController.php
    // UserController.php
    public function index(Request $request)
    {
        $search = $request->query('search');
        
        $query = User::query();
        $query->join('resellers', 'resellers.user_id', '=', 'users.id');


        if ($search) {
            $query->where('users.username', 'LIKE', "%$search%")
                ->orWhere('users.email', 'LIKE', "%$search%")
                ->orWhere('resellers.name', 'LIKE', "%$search%");
                
        }

        $users = $query->paginate(10);

        return view('users.index', compact('users', 'search'));
    }


    public function destroy(User $user)
    {
        $user->delete();

        return redirect()->route('users.index')->with('success', 'User deleted successfully.');
    }



}


